<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

$assessment_id = $_POST['assessment_id'] ?? 0;

/* 📥 SAVE LAST PAGE ANSWERS INTO SESSION (VERY IMPORTANT) */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST['answers'] ?? [] as $qid => $ans) {
        $_SESSION['exam_answers'][$assessment_id][$qid] = $ans;
    }
}

/* 📥 LOAD ALL SAVED ANSWERS */
$answers = $_SESSION['exam_answers'][$assessment_id] ?? [];


/* 🔐 RE-CHECK ACCESS (VERY IMPORTANT) */
$check = $pdo->prepare("
SELECT a.id
FROM assessments a
JOIN courses c ON a.course_id = c.id
JOIN subscriptions s ON s.course_id = c.id
WHERE a.id = :aid
AND s.user_id = :uid
AND s.payment_status = 'paid'
");
$check->execute([
    'aid' => $assessment_id,
    'uid' => $user_id
]);

if (!$check->fetch()) {
    die("❌ Access denied");
}

/* 🚫 PREVENT MULTIPLE ATTEMPTS */
$attempt = $pdo->prepare("
SELECT id FROM results
WHERE user_id = :uid AND assessment_id = :aid
LIMIT 1
");
$attempt->execute([
    'uid' => $user_id,
    'aid' => $assessment_id
]);

if ($attempt->fetch()) {
    die("❌ You have already submitted this assessment.");
}

/* 📚 FETCH QUESTIONS */
$stmt = $pdo->prepare("
SELECT id, correct_option
FROM questions
WHERE assessment_id = :aid
");
$stmt->execute(['aid' => $assessment_id]);
$questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

$score = 0;
$total = count($questions);

/* 🧮 MARKING */
foreach ($questions as $q) {
    if (
    isset($answers[$q['id']]) &&
    strtolower($answers[$q['id']]) === strtolower($q['correct_option'])
) {
    $score++;
}

}

/* 💾 SAVE RESULT */
$save = $pdo->prepare("
INSERT INTO results
(user_id, assessment_id, score, total_questions, created_at)
VALUES (:uid, :aid, :score, :total, NOW())
");
$save->execute([
    'uid'   => $user_id,
    'aid'   => $assessment_id,
    'score' => $score,
    'total' => $total
]);



/* 🧠 SAVE ANSWERS FOR REVIEW */
$_SESSION['review_answers'][$assessment_id] = $answers;

/* optional cleanup */
unset($_SESSION['exam_answers'][$assessment_id]);


/* ➡ REDIRECT TO RESULT PAGE */
header("Location: result.php?id=".$assessment_id);
exit;
