<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$assessment_id = $_GET['id'] ?? 0;

/* Get all questions with explanations */
$stmt = $pdo->prepare("
SELECT id, question, option_a, option_b, option_c, option_d,
       correct_option, explanation_correct, explanation_wrong
FROM questions
WHERE assessment_id = :aid
ORDER BY id ASC
");
$stmt->execute(['aid' => $assessment_id]);
$questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* Student answers */
$answers = $_SESSION['review_answers'][$assessment_id] ?? [];
?>

<!doctype html>
<html>
<head>
<title>Answer Review</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
<h3>📘 Answer Review</h3>

<?php foreach ($questions as $i => $q): ?>
<?php
$studentAnswer = $answers[$q['id']] ?? '';
$isCorrect = strtolower($studentAnswer) === strtolower($q['correct_option']);
?>

<div class="card mb-3 <?= $isCorrect ? 'border-success' : 'border-danger' ?>">
<div class="card-body">

<p><strong>Q<?= $i+1 ?>.</strong> <?= htmlspecialchars($q['question']) ?></p>

<p>✅ <strong>Correct Answer:</strong> <?= strtoupper($q['correct_option']) ?></p>
<p>🧑 <strong>Your Answer:</strong> <?= $studentAnswer ? strtoupper($studentAnswer) : 'Not Answered' ?></p>

<?php if ($isCorrect): ?>
<p class="text-success">✔ You got it correct!</p>
<?php if (!empty($q['explanation_correct'])): ?>
<div class="alert alert-info">
<strong>Explanation:</strong><br>
<?= nl2br(htmlspecialchars($q['explanation_correct'])) ?>
</div>
<?php endif; ?>
<?php else: ?>
<p class="text-danger">❌ You got it wrong</p>
<?php if (!empty($q['explanation_wrong'])): ?>
<div class="alert alert-warning">
<strong>Why wrong / Failed:</strong><br>
<?= nl2br(htmlspecialchars($q['explanation_wrong'])) ?>
</div>
<?php endif; ?>
<?php endif; ?>

</div>
</div>

<?php endforeach; ?>

<a href="result.php?id=<?= $assessment_id ?>" class="btn btn-secondary">⬅ Back to Result</a>

</div>
</body>
</html>
