<?php
session_start();
// require_once __DIR__ . '/includes/config.php';
require_once 'Config.php';

$errors = [];
$old = ['fullname'=>'','email'=>''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname = trim($_POST['fullname'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';

    $old['fullname'] = $fullname;
    $old['email'] = $email;

    if ($fullname === '') $errors[] = 'Name is required.';
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Valid email is required.';
    if (strlen($password) < 6) $errors[] = 'Password must be at least 6 characters.';
    if ($password !== $password_confirm) $errors[] = 'Password confirmation does not match.';

    if (empty($errors)) {
        // check unique email
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = :email LIMIT 1');
        $stmt->execute([':email' => $email]);
        if ($stmt->fetch()) {
            $errors[] = 'Email already registered. Try logging in.';
        } else {
            $pw_hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('INSERT INTO users (fullname, email, password, role, created_at) VALUES (:fullname, :email, :password, :role, NOW())');
            $stmt->execute([
                ':fullname' => $fullname,
                ':email' => $email,
                ':password' => $pw_hash,
                ':role' => 'student'
            ]);
            // auto-login
            $userId = $pdo->lastInsertId();
            $_SESSION['user'] = ['id' => $userId, 'fullname' => $fullname, 'email' => $email, 'role' => 'student'];
            header('Location: dashboard.php');
            exit;
        }
    }
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="row justify-content-center">
  <div class="col-md-6">
    <h3><center> Register <center> </h3>

    <?php if(!empty($errors)): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach($errors as $e): ?><li><?=htmlspecialchars($e)?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post" novalidate>
      <div class="mb-3">
        <label class="form-label">Full name</label>
        <input type="text" name="fullname" class="form-control" value="<?=htmlspecialchars($old['fullname'])?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Email address</label>
        <input type="email" name="email" class="form-control" value="<?=htmlspecialchars($old['email'])?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Confirm Password</label>
        <input type="password" name="password_confirm" class="form-control" required>
      </div>

      <button class="btn btn-primary" type="submit">Create account</button>
      <a href="login.php" class="btn btn-link">Already have an account? Login</a>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
