<?php
header('Content-Type: application/json');
require_once 'config.php';

$reference = $_POST['reference'] ?? '';
$subscription_id = $_POST['subscription_id'] ?? '';

if (!$reference || !$subscription_id) {
    echo json_encode(["status"=>"error","message"=>"Invalid data"]);
    exit;
}

// Paystack secret key
$secret_key = 'sk_test_b1685f14b9c45266989ea5cacad076c5053f45ad';

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . urlencode($reference),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secret_key",
        "Cache-Control: no-cache"
    ],
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo json_encode(["status"=>"error","message"=>"cURL Error: $err"]);
    exit;
}

$result = json_decode($response, true);

// Check payment success
if (isset($result['status']) && $result['status'] && $result['data']['status'] === 'success') {
    $stmt = $pdo->prepare("UPDATE subscriptions SET payment_status = 'paid' WHERE id = :id");
    $stmt->execute(['id' => $subscription_id]);

    echo json_encode(["status"=>"success","message"=>"Payment successful! Subscription activated."]);
} else {
    echo json_encode(["status"=>"error","message"=>"Payment failed or not verified"]);
}
