<?php
header('Content-Type: application/json');
require_once 'config.php'; // include your PDO connection

// Get POST data
$subscription_id = $_POST['subscription_id'] ?? '';

if (!$subscription_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid subscription ID'
    ]);
    exit;
}

try {
    // Fetch subscription from DB
    $stmt = $pdo->prepare('SELECT payment_status FROM subscriptions WHERE id = :id');
    $stmt->execute(['id' => $subscription_id]);
    $subscription = $stmt->fetch();

    if (!$subscription) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Subscription not found'
        ]);
        exit;
    }

    // Check payment status
    if ($subscription['payment_status'] === 'paid') {
        echo json_encode([
            'status' => 'success',
            'message' => 'Payment verified. Subscription is active.'
        ]);
    } else {
        echo json_encode([
            'status' => 'pending',
            'message' => 'Payment not verified yet. Please wait for admin confirmation.'
        ]);
    }

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
