<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname = $_POST['fullname'];
    $email    = $_POST['email'];
    $password = $_POST['password'];

    // Hash password
    $hashed = password_hash($password, PASSWORD_DEFAULT);

    // Insert into users table
    $stmt = $pdo->prepare("
        INSERT INTO users (fullname, email, password, role)
        VALUES (?, ?, ?, 'admin')
    ");
    $stmt->execute([$fullname, $email, $hashed]);

    // Insert into admins table
    $stmt2 = $pdo->prepare("
        INSERT INTO admins (fullname, email, password)
        VALUES (?, ?, ?)
    ");
    $stmt2->execute([$fullname, $email, $hashed]);

    $success = "Admin registered successfully!";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Register Admin</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #198754, #0d6efd);
            min-height: 100vh;
        }
        .register-card {
            border-radius: 15px;
        }
        .form-control {
            height: 45px;
        }
    </style>
</head>

<body class="d-flex align-items-center justify-content-center">

<div class="col-md-4 col-sm-10">
    <div class="card shadow-lg register-card">
        <div class="card-body p-4">

            <h3 class="text-center fw-bold mb-4">
                <i class="bi bi-person-plus-fill text-success"></i><br>
                Register Admin
            </h3>

            <?php if (isset($success)) : ?>
                <div class="alert alert-success text-center">
                    <?= htmlspecialchars($success) ?>
                </div>
            <?php endif; ?>

            <form method="POST">

                <div class="mb-3">
                    <label class="form-label">Full Name</label>
                    <input type="text" name="fullname" class="form-control" placeholder="Enter full name" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Email Address</label>
                    <input type="email" name="email" class="form-control" placeholder="Enter email address" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" placeholder="Create password" required>
                </div>

                <button type="submit" class="btn btn-success w-100 py-2">
                    <i class="bi bi-person-check-fill"></i> Register Admin
                </button>

            </form>

        </div>
    </div>

    <p class="text-center text-white mt-3 small">
        © <?= date('Y') ?> Admin Management System
    </p>
</div>

</body>
</html>
