<?php
// config.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!function_exists('is_logged_in')) {
    function is_logged_in() {
        return isset($_SESSION['user']);
    }
}
// Database
$dsn = 'mysql:host=localhost;dbname=vsb;charset=utf8';
$username = 'root';
$password = '';

try {
    $pdo = new PDO($dsn, $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("DB Error: " . $e->getMessage());
}

// AUTH HELPERS
function is_logged_in() {
    return isset($_SESSION['user']) && is_array($_SESSION['user']);
}

function current_user() {
    return $_SESSION['user'] ?? null;
}
