
// =======================
// Load Categories
// =======================
fetch("php/fetch_categories.php")
  .then(res => res.json())
  .then(categories => {
    const wrapper = document.getElementById("categories");
    
    categories.forEach(cat => {
      const div = document.createElement("div");
      div.classList.add("category-item");
      div.textContent = cat.name;

      div.onclick = () => {
        document.querySelectorAll(".category-item")
          .forEach(el => el.classList.remove("selected"));

        div.classList.add("selected"); 
        fetchCourses(cat.id);
      };

      wrapper.appendChild(div);
    });
  })
  .catch(err => console.log("Error:", err));




// =======================
// Fetch Courses
// =======================
function fetchCourses(category_id) {
  fetch("php/fetch_courses.php", {
    method: "POST",
    headers: {"Content-Type": "application/x-www-form-urlencoded"},
    body: `category_id=${category_id}`
  })
    .then(res => res.json())
    .then(courses => {
      const wrapper = document.getElementById("courses");
      wrapper.innerHTML = "";

      courses.forEach(course => {
        const div = document.createElement("div");
        div.classList.add("course-item");

        div.innerHTML = `
  <div class="course-video">

    <!-- Thumbnail preview -->
    <img src="../thumbnails/${course.thumbnail}"
         class="thumb"
         onclick="openVideoModal('../courses/${course.file}')">

    <!-- open main video watching page -->
    <h4 onclick="openVideoPage(${course.id})">${course.name}</h4>

    Level: ${course.level}<br>
    Type: ${course.type}<br>
    Duration: ${course.duration} days<br>
    Price: ₦${course.price}<br>
  </div>


  <button class="subscribe-btn"
    onclick="subscribe(${course.id})">
    Subscribe
  </button>
`;
        wrapper.appendChild(div);
      });
    })
    .catch(err => console.log("Error:", err));
}





// =======================
// Popup video player
// =======================
function openVideoModal(url){
  const modal = document.getElementById("videoModal");
  const vid = document.getElementById("popupVideo");

  vid.src = url;
  modal.style.display = "flex";
}

function closeVideoModal(){
  const modal = document.getElementById("videoModal");
  const vid = document.getElementById("popupVideo");

  vid.pause();
  vid.src = "";
  modal.style.display = "none";
}


// =======================
// Open Full Watch Page
// =======================
function openVideoPage(id){
  window.location.href = `php/video.php?id=${id}`;
}





// =======================
// Subscribe Form
// =======================
function subscribe(course_id) {
  const box = document.getElementById("subscriptionForm");

  box.innerHTML = `
    <h3>Subscribe to Course</h3>

    <form id="subForm">

      <label>Email:</label>
      <input type="email" id="email" required>

      <label>Duration:</label>
      <select id="duration">
        <option value="30">30 days</option>
        <option value="60">60 days</option>
        <option value="90">90 days</option>
      </select>

      <button>Subscribe Now</button>
    </form>
  `;

  document.getElementById("subForm").onsubmit = function(e){
    e.preventDefault();

    const email = document.getElementById("email").value;
    const duration = document.getElementById("duration").value;

    fetch("php/subscribe.php", {
      method: "POST",
      headers: {"Content-Type": "application/x-www-form-urlencoded"},
      body: `email=${email}&duration=${duration}&course_id=${course_id}`
    })
    .then(res => res.text())
    .then(msg => {
      box.innerHTML = `
        <div class="success">${msg}</div>
      `;
    })
    .catch(err => console.log(err));
  };
}








// subscribe 

function subscribe(course_id, coursePrice) {
  const box = document.getElementById("subscriptionForm");

  box.innerHTML = `
    <h3>Subscribe to Course</h3>
    <form id="subForm">
      <input type="hidden" name="course_id" value="${course_id}">
      <input type="hidden" name="amount" id="planAmount">

      <label>Email:</label>
      <input type="email" name="email" required>

      <label>Subscription Plan:</label>
      <select name="plan" id="planSelect" required>
        <option value="regular">Regular (Basic Access)</option>
        <option value="premium">Premium (Full Access)</option>
      </select>

      <p id="priceDisplay" style="margin-top:10px; font-weight:bold;"></p>

      <label>Duration:</label>
      <select name="duration">
        <option value="30">30 days</option>
        <option value="60">60 days</option>
        <option value="90">90 days</option>
      </select>

<label>Payment Method:</label>
<select name="payment_method" id="paymentMethod" required>
  <option value="paystack">Pay Online (Card/Transfer)</option>
  <option value="manual">Manual Bank Transfer</option>
</select>


      <br>
      <button type="submit">Subscribe Now</button>
      <button type="button" id="closeForm">Close</button>
    </form>
  `;

  const planSelect = document.getElementById("planSelect");
  const amountField = document.getElementById("planAmount");
  const priceDisplay = document.getElementById("priceDisplay");
  const form = document.getElementById("subForm");

  function updatePrice() {
    let amount = coursePrice;
    if (planSelect.value === "premium") amount *= 2;
    amountField.value = amount;
    priceDisplay.textContent = "Price: ₦" + amount.toLocaleString();
  }

  updatePrice();
  planSelect.addEventListener("change", updatePrice);

  document.getElementById("closeForm").onclick = () => box.innerHTML = "";

  // --- Paystack AJAX ---
  form.onsubmit = function(e) {
    e.preventDefault();

    const email = form.email.value;
    const plan = planSelect.value;
    const duration = form.duration.value;
     const paymentMethod = document.getElementById("paymentMethod").value;
    let amount = coursePrice;
    if (plan === "premium") amount *= 2;

 // Generate a reference
    const reference = 'SUB_' + Math.floor(Math.random() * 1000000000 + 1);


if(paymentMethod === "manual") {
    // Display account details for manual transfer
    box.innerHTML = `
      <h3>Manual Payment Instructions</h3>
      <p>Please transfer <strong>₦${amount.toLocaleString()}</strong> to the following bank account:</p>
      <p><strong>Bank:</strong> Zenith Bank</p>
      <p><strong>Account Name:</strong> CrystaLink Edu</p>
      <p><strong>Account Number:</strong> 1234567890</p>
      <p>After payment, send your proof of payment to <strong>payments@crystallink.ng</strong> with this reference: <strong>${reference}</strong></p>
      <button type="button" id="closeForm">Close</button>
    `;

    document.getElementById("closeForm").onclick = () => box.innerHTML = "";

    // Save subscription in DB with reference and "pending" status
    fetch("php/subscribe.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: new URLSearchParams({
        email: email,
        course_id: course_id,
        duration: duration,
        plan: plan,
        amount: amount,
        reference: reference,
        payment_method: "manual"
      })
    }).then(res => res.json())
      .then(data => console.log("Manual subscription saved:", data));

    return; // stop execution here for manual payment
  }

  // Otherwise continue with Paystack




//Save subscription in DB with the reference
    fetch("php/subscribe.php", {
      method: "POST",

      headers: {
    "Content-Type": "application/x-www-form-urlencoded"
  },
      body: new URLSearchParams({
        email: email,
        course_id: course_id, // correct variable here
        duration: duration,
        plan: plan,
        amount: amount,
        reference: reference  // <-- send reference
      })
    })
    .then(res => res.json())
    .then(data => {
      let handler = PaystackPop.setup({
        // key: 'YOUR_PAYSTACK_PUBLIC_KEY',
        key: 'pk_test_263fe98c1ab94e9f489c7d4c6dec6595f36d1472',
        email: data.email,
        amount: data.amount * 100,
        currency: "NGN",
        ref: '' + Math.floor(Math.random() * 1000000000 + 1),
        onClose: function() {
          alert('Payment window closed.');
        },
        callback: function(response) {
          fetch('php/verify_payment.php', {
            method: 'POST',
            body: new URLSearchParams({
              reference: response.reference,
              subscription_id: data.subscription_id
            })
          })
          .then(res => res.text())
          .then(msg => {
            alert(msg);
            // unlock video/pdf here
          });
        }
      });
      handler.openIframe();
    });


  };
