<?php
// require_once __DIR__ . '/includes/header.php';
?>

<!DOCTYPE html>
<html>
<head>
    <title>Course Subscription</title>
    <!-- <link rel="stylesheet" href="style.css"> -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f4f7;
            margin: 0;
            padding: 0;
        }


/* ===========================
   Videos in courses
=========================== */
#courses video {
    width: 100%;           /* full width of the container */
    max-width: 400px;      /* limit the size */
    height: auto;          /* keep aspect ratio */
    aspect-ratio: 16 / 9;  /* force landscape orientation */
    border-radius: 8px;
    margin-bottom: 15px;
    object-fit: cover;     /* crop or scale nicely */
    box-shadow: 0 3px 10px rgba(0,0,0,0.15);
    transition: transform 0.2s;
}

#courses video:hover {
    transform: scale(1.03);
}



        .container {
            max-width: 900px;
            margin: 50px auto;
            background: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
        }

        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
        }

        #categories, #courses, #subscriptionForm {
            margin-bottom: 30px;
        }

        .category-item, .course-item {
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            margin-bottom: 10px;
            cursor: pointer;
            transition: background 0.3s, transform 0.2s;
        }

        .category-item:hover, .course-item:hover {
            background: #0d6efd;
            color: #fff;
            transform: translateY(-2px);
        }

        .selected {
            background: #198754 !important;
            color: #fff;
        }

        #courses .course-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .subscribe-btn {
            padding: 6px 12px;
            background: #0d6efd;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            transition: background 0.3s;
        }

        .subscribe-btn:hover {
            background: #0a58ca;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        form input, form select, form button {
            padding: 10px;
            border-radius: 4px;
            border: 1px solid #ddd;
        }

        form button {
            background: #198754;
            color: #fff;
            border: none;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }

        form button:hover {
            background: #146c43;
        }

        .error {
            background: #ffdddd;
            color: #b10000;
            padding: 10px;
            border-left: 4px solid red;
            margin-bottom: 15px;
        }

        .success {
            background: #ddffdd;
            color: #006400;
            padding: 10px;
            border-left: 4px solid green;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>View Our Courses</h2>

        <div id="categories">
            <!-- Categories will load here -->
        </div>
        <br><br>

        <div id="courses">
            <!-- Courses will load here -->
        </div>
<br><br>

<div id="courses"></div>

<div id="pagination" style="margin-top:20px; text-align:center;"></div>


<br><br>
        <div id="subscriptionForm">
            <!-- Subscription form will load here -->
        </div>
    </div>

<div id="subscriptionForm" style="
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.6);
  display: none;
  justify-content: center;
  align-items: center;
  z-index: 9999;
"></div>



<!-- Load Paystack library -->
<script src="https://js.paystack.co/v1/inline.js"></script>

<!-- Load your script -->

    <script src="js/script.js"></script>
</body>
</html>
