<?php
// download.php
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/auth.php';


$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare('SELECT * FROM courses WHERE id = :id');
$stmt->execute([':id'=>$id]);
$course = $stmt->fetch();
if(!$course) { http_response_code(404); echo 'Course not found'; exit; }


// if free, allow; else check subscriptions table
if($course['price'] > 0){
if(!is_logged_in()) { header('Location: /login.php'); exit; }
$stmt = $pdo->prepare('SELECT 1 FROM subscriptions WHERE user_id = :uid AND course_id = :cid AND paid_at IS NOT NULL');
$stmt->execute([':uid'=>current_user_id(), ':cid'=>$id]);
if(!$stmt->fetchColumn()){ echo 'You need to purchase this course to download curriculum.'; exit; }
}


$path = __DIR__.'/assets/uploads/'.basename($course['curriculum_file']);
if(!file_exists($path)){ http_response_code(404); echo 'File not found'; exit; }


// send file
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="'.basename($path).'"');
header('Content-Length: '.filesize($path));
readfile($path);
exit;