<?php
// session_start();
require "php/config.php";   // PDO connection

// ===== CHECK LOGIN ===== //
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

// ===== FETCH USER DETAILS ===== //
$user_id = $_SESSION['user']['id'];

$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$user){
    echo "User not found.";
    exit;
}


$fullname = $user['fullname'];
$role     = ucfirst($user['role']);
$photo    = $user['photo'] ?? "assets/hero-video-placeholder.png"; // Optional, if you plan to add profile photos

?>
<!DOCTYPE html>
<html>
<head>
    <title>Student Dashboard</title>

    <!-- Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

    <style>
        body{ background:#f8f9fa; }
        .dash-card{
            border-radius:15px;
            transition:0.3s;
            cursor:pointer;
        }
        .dash-card:hover{
            transform:scale(1.03);
            background:#eef3ff;
        }
        .profile-img{
            width:90px;height:90px;border-radius:50%;object-fit:cover;border:3px solid #fff;
        }
    </style>
    <style>
/* Optional hover effect */
.dash-card {
    border-radius: 10px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.dash-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 0.75rem 1.5rem rgba(0, 0, 0, 0.15);
}

/* Responsive text alignment */
.dash-card h4, .dash-card p {
    margin: 0;
}
</style>
</head>
<body>

<!-- TOP NAV -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <span class="navbar-brand">Student Dashboard</span>

    <div class="float-end">
      <a href="logout.php" class="btn btn-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<!-- HEADER -->
<div class="container mt-4 text-center">
    <img src="<?php echo $photo; ?>" class="profile-img mb-2">
    <h2>Welcome, <?php echo $fullname; ?>!</h2>
    <p class="text-muted">Role: <?php echo $role; ?></p>
</div>

<!-- DASHBOARD MENU -->
<div class="container mt-4">
    <div class="row g-3">

        <div class="col-md-4">
            <a href="index1.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📚 Courses</h4>
                    <p>Browse all learning materials</p>
                </div>
            </a>
        </div>

        <!-- <div class="col-md-4">
            <a href="subjects.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📘 Subjects</h4>
                    <p>Select subjects and topics</p>
                </div>
            </a>
        </div> -->

        <div class="col-md-4">
            <a href="login.php?redirect=live_classes.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>🎓 Class Room</h4>
                    <p>Continue your enrolled classes</p>
                </div>
            </a>
        </div>

        <div class="col-md-4">
            <a href="assessments.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📝 Assessments</h4>
                    <p>Take tests </p>
                </div>
            </a>
        </div>

        <div class="col-md-4">
            <a href="student_grades.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📚 Assignment Score</h4>
                    <p>View Now</p>
                </div>
            </a>
        </div> 

        <div class="col-md-4">
    <a href="assignments.php" class="text-decoration-none">
        <div class="p-4 bg-white shadow dash-card text-center">
            <h4>📂 Assignments</h4>
            <p>View or submit assignments</p>
        </div>
    </a>
</div>
<div class="col-md-4 col-sm-6 mb-3">
    <a href="subscriptions.php" class="text-decoration-none">
        <div class="p-4 bg-white shadow dash-card text-center h-100 hover-shadow">
            <h4>💳 Subscriptions</h4>
            <p>View your subscribed courses</p>
        </div>
    </a>
</div>

        <!-- <div class="col-md-4">
            <a href="profile.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👤 Account</h4>
                    <p>Manage profile settings</p>
                </div>
            </a>
        </div> -->

        <!-- <div class="col-md-6">
            <a href="view_profile.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👁 View My Profile</h4>
                    <p>See your public student profile</p>
                </div>
            </a>
        </div> -->

        <!-- <div class="col-md-6">
            <a href="public_profiles.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👥 Public Profiles</h4>
                    <p>View other students</p>
                </div>
            </a>
        </div> -->

        <div class="col-md-12">
            <a href="index.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>🏠 Home</h4>
                </div>
            </a>
        </div>

    </div>
</div>

</body>
</html>
