<?php
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

$sql = "
SELECT 
    a.id,
    a.assessment_title,
    a.total_questions,
    a.duration,
    c.name AS course_name,
    cat.name AS category_name
FROM assessments a
JOIN courses c ON a.course_id = c.id
JOIN categories cat ON c.category_id = cat.id
JOIN subscriptions s ON s.course_id = c.id
WHERE s.user_id = :user_id
AND s.payment_status = 'paid'
";


$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$assessments = $stmt->fetchAll();
?>

<!doctype html>
<html>
<head>
<title>My Assessments</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
  <h3>📝 My Assessments</h3>

  <?php if(empty($assessments)): ?>
    <div class="alert alert-warning">
      You have no assessments. Subscribe to a course.
    </div>
  <?php endif; ?>

  <div class="row">
    <?php foreach($assessments as $a): ?>
      <div class="col-md-4">
        <div class="card mb-3 shadow-sm">
          <div class="card-body">
            <h5><?= htmlspecialchars($a['assessment_title']) ?></h5>
            <p><strong>Course:</strong> <?= htmlspecialchars($a['course_name']) ?></p>

            <p><strong>Category:</strong> <?= $a['category_name'] ?></p>
            <p>⏱ <?= $a['duration'] ?> minutes</p>
            <p>❓ <?= $a['total_questions'] ?> questions</p>

            <a href="start_assessment.php?id=<?= $a['id'] ?>" 
               class="btn btn-primary btn-sm">
               Start
            </a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

</body>
</html>
