<?php
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

$stmt = $pdo->query("
    SELECT * FROM contact_messages
    ORDER BY created_at DESC
");
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
<title>Admin | Contact Messages</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
<h3 class="mb-4">📩 Contact Messages</h3>

<table class="table table-bordered bg-white shadow-sm">
<thead class="table-dark">
<tr>
    <th>#</th>
    <th>Name</th>
    <th>Email</th>
    <th>Subject</th>
    <th>Message</th>
    <th>Date</th>
</tr>
</thead>
<tbody>
<?php foreach($messages as $i => $m): ?>
<tr>
    <td><?= $i+1 ?></td>
    <td><?= htmlspecialchars($m['name']) ?></td>
    <td><?= htmlspecialchars($m['email']) ?></td>
    <td><?= htmlspecialchars($m['subject']) ?></td>
    <td><?= nl2br(htmlspecialchars($m['message'])) ?></td>
    <td><?= date('d M Y h:i A', strtotime($m['created_at'])) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<a href="dashboard.php" class="btn btn-secondary">⬅ Back</a>
</div>
</body>
</html>
