<?php
session_start();
require_once '../php/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $fullname = $_POST['fullname'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($fullname) || empty($password)) {
        $error = 'Please fill all fields';
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admins WHERE fullname = :fullname");
        $stmt->execute(['fullname' => $fullname]);
        $admin = $stmt->fetch();

        if (!$admin || !password_verify($password, $admin['password'])) {
            $error = 'Invalid username or password';
        } else {
            $_SESSION['user'] = [
    'id' => $admin['id'],
    'fullname' => $admin['fullname'],
    'email' => $admin['email'],
    'role' => 'admin'
];
;
            header("Location: dashboard.php");
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #0d6efd, #6610f2);
            min-height: 100vh;
        }
        .login-card {
            border-radius: 15px;
        }
        .form-control {
            height: 45px;
        }
    </style>
</head>

<body class="d-flex align-items-center justify-content-center">

<div class="col-md-4 col-sm-10">
    <div class="card shadow-lg login-card">
        <div class="card-body p-4">

            <h3 class="text-center mb-4 fw-bold">
                <i class="bi bi-shield-lock-fill text-primary"></i><br>
                Admin Login
            </h3>

            <?php if (isset($error)) : ?>
                <div class="alert alert-danger text-center">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST">

                <div class="mb-3">
                    <label class="form-label">Full Name</label>
                    <input type="text" name="fullname" class="form-control" placeholder="Enter fullname" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                </div>

                <button type="submit" class="btn btn-primary w-100 py-2">
                    <i class="bi bi-box-arrow-in-right"></i> Login
                </button>

            </form>

        </div>
    </div>

    <p class="text-center text-white mt-3 small">
        © <?= date('Y') ?> Admin Panel
    </p>
</div>

</body>
</html>
