<?php
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

// Ensure admin is logged in
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$assignment_id = $_GET['id'] ?? 0;

// Handle grade submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submission_id'])) {
    $submission_id = $_POST['submission_id'];
    $grade = $_POST['grade'] ?? null;
    $feedback = $_POST['feedback'] ?? '';

    $updateStmt = $pdo->prepare("
        UPDATE assignment_submissions
        SET grade = :grade, feedback = :feedback
        WHERE id = :sid
    ");
    $updateStmt->execute([
        'grade' => $grade,
        'feedback' => $feedback,
        'sid' => $submission_id
    ]);

    $successMsg = "✅ Grade & feedback saved successfully!";
}

// Fetch assignment details
$assStmt = $pdo->prepare("SELECT title FROM assignments WHERE id = ?");
$assStmt->execute([$assignment_id]);
$assignment = $assStmt->fetch();

if (!$assignment) {
    die("❌ Assignment not found.");
}

// Fetch submissions
$stmt = $pdo->prepare("
SELECT s.id, u.fullname AS student_name, s.answer, s.file_path, s.grade, s.feedback, s.submitted_at
FROM assignment_submissions s
JOIN users u ON u.id = s.user_id
WHERE s.assignment_id = :aid
ORDER BY s.submitted_at DESC

");
$stmt->execute(['aid' => $assignment_id]);
$submissions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-5">
    <h3>Grade Assignment: <?= htmlspecialchars($assignment['title'] ?? 'N/A') ?></h3>

    <?php if (!empty($successMsg)): ?>
        <div class="alert alert-success"><?= htmlspecialchars($successMsg) ?></div>
    <?php endif; ?>

    <?php if (empty($submissions)): ?>
        <p>No submissions yet.</p>
    <?php else: ?>
        <div class="accordion" id="submissionsAccordion">
        <?php foreach ($submissions as $i => $sub): 
            $studentName = $sub['student_name'] ?? 'Unknown Student';
            $answer = $sub['answer'] ?? '';
            $grade = $sub['grade'] ?? '';
            $feedback = $sub['feedback'] ?? '';
        ?>
            <div class="accordion-item mb-2">
                <h2 class="accordion-header" id="heading<?= $i ?>">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $i ?>" aria-expanded="false" aria-controls="collapse<?= $i ?>">
                        <?= htmlspecialchars($studentName) ?> 
                        <?php if ($grade !== ''): ?>
                            - <span class="badge bg-success"><?= htmlspecialchars($grade) ?>%</span>
                        <?php endif; ?>
                    </button>
                </h2>
                <div id="collapse<?= $i ?>" class="accordion-collapse collapse" aria-labelledby="heading<?= $i ?>" data-bs-parent="#submissionsAccordion">
                    <div class="accordion-body">
                        <p><strong>Answer:</strong></p>
                        <div class="border p-2 mb-2"><?= nl2br(htmlspecialchars($answer)) ?></div>

                        <?php if (!empty($sub['file_path'])): ?>
                            <p><strong>Uploaded File:</strong> <a href="<?= htmlspecialchars($sub['file_path']) ?>" target="_blank">View File</a></p>
                        <?php endif; ?>

                        <form method="post" class="row g-2">
                            <input type="hidden" name="submission_id" value="<?= $sub['id'] ?>">

                            <div class="col-md-3">
                                <label class="form-label">Grade (%)</label>
                                <input type="number" name="grade" class="form-control" value="<?= htmlspecialchars($grade) ?>" min="0" max="100" required>
                            </div>
                            <div class="col-md-7">
                                <label class="form-label">Feedback</label>
                                <textarea name="feedback" class="form-control" rows="2"><?= htmlspecialchars($feedback) ?></textarea>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-success w-100">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="mt-4">
        <a href="assignments.php" class="btn btn-secondary">⬅ Back to Assignments</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
