<?php
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';

$id = $_GET['id'] ?? null;

// Fetch course
$stmt = $pdo->prepare('SELECT * FROM courses WHERE id = :id');
$stmt->execute(['id' => $id]);
$course = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$course) {
    echo "Course not found.";
    exit;
}

// Fetch categories for dropdown
$catStmt = $pdo->query('SELECT id, name FROM categories ORDER BY name ASC');
$categories = $catStmt->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $level = $_POST['level'];
    $type = $_POST['type'];
    $duration = $_POST['duration'];
    $price = $_POST['price'];
    $category_id = $_POST['category_id'];

    $stmt = $pdo->prepare('UPDATE courses SET name = :name, level = :level, type = :type, duration = :duration, price = :price, category_id = :category_id WHERE id = :id');
    $stmt->execute([
        'name' => $name,
        'level' => $level,
        'type' => $type,
        'duration' => $duration,
        'price' => $price,
        'category_id' => $category_id,
        'id' => $id
    ]);

    header('Location: courses.php');
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit Course</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="background: #f8f9fa;">

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">✏️ Edit Course</h4>
                </div>
                <div class="card-body">

                    <form method="post">

                        <div class="mb-3">
                            <label class="form-label">Course Name</label>
                            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($course['name'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Level</label>
                            <input type="text" name="level" class="form-control" value="<?= htmlspecialchars($course['level'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Type</label>
                            <input type="text" name="type" class="form-control" value="<?= htmlspecialchars($course['type'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Duration (minutes)</label>
                            <input type="number" name="duration" class="form-control" value="<?= htmlspecialchars($course['duration'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Price (₦)</label>
                            <input type="number" name="price" class="form-control" value="<?= htmlspecialchars($course['price'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Category</label>
                            <select name="category_id" class="form-select" required>
                                <option value="">-- Select Category --</option>
                                <?php foreach($categories as $cat): ?>
                                    <option value="<?= $cat['id'] ?>" <?= ($cat['id'] == ($course['category_id'] ?? '')) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($cat['name'] ?? '') ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="d-flex justify-content-between">
                            <a href="courses.php" class="btn btn-secondary">Cancel</a>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
