<?php
session_start();
require_once '../php/config.php';

// Optional admin protection
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$stmt = $pdo->query("
    SELECT cl.*, c.name AS course_name
    FROM course_links cl
    INNER JOIN courses c ON c.id = cl.course_id
    ORDER BY cl.created_at DESC
");
$links = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Course Links</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background-color: #f4f6f9;
        }
        .card {
            border-radius: 15px;
        }
        .table th {
            background-color: #0d6efd;
            color: #fff;
        }
        .link-text {
            max-width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            display: inline-block;
        }
    </style>
</head>

<body>

<div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">
            <i class="bi bi-camera-video-fill text-primary"></i>
            Zoom / Google Meet Links
        </h3>

        <a href="link_form.php" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add New Link
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">

            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Course</th>
                        <th>Platform</th>
                        <th>Meeting Link</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>

                <?php if (count($links) === 0): ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted py-4">
                            No links available
                        </td>
                    </tr>
                <?php endif; ?>

                <?php foreach ($links as $l): ?>
                    <tr>
                        <td><?= $l['id'] ?></td>
                        <td><?= htmlspecialchars($l['course_name']) ?></td>
                        <td>
                            <span class="badge bg-success">
                                <?= htmlspecialchars($l['platform']) ?>
                            </span>
                        </td>
                        <td>
                            <a href="<?= htmlspecialchars($l['link']) ?>"
                               target="_blank"
                               class="link-text">
                               <?= htmlspecialchars($l['link']) ?>
                            </a>
                        </td>
                        <td class="text-center">
                            <a href="link_form.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil-square"></i>
                            </a>

                            <a href="delete.php?type=link&id=<?= $l['id'] ?>"
                               class="btn btn-sm btn-danger"
                               onclick="return confirm('Delete this link?')">
                               <i class="bi bi-trash"></i>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>

                </tbody>
            </table>

        </div>
    </div>

</div>

<?php require_once '../includes/footer.php'; ?>
</body>
</html>
