<?php 
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';
// require_once 'admin_guard.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$stmt = $pdo->query("
SELECT a.id, a.assessment_title, c.name
FROM assessments a
JOIN courses c ON a.course_id = c.id
");
$assessments = $stmt->fetchAll();
?>

<h3>Assessments</h3>
<a href="add_assessment.php" class="btn btn-primary">Add Assessment</a>

<table class="table mt-3">
<tr><th>Title</th><th>Course</th><th>Actions</th></tr>
<?php foreach($assessments as $a): ?>
<tr>
<td><?= $a['assessment_title'] ?></td>
<td><?= $a['name'] ?></td>
<td>
  <a href="questions.php?id=<?= $a['id'] ?>" class="btn btn-sm btn-info">Questions</a>
</td>
</tr>
<?php endforeach; ?>
</table>
