<?php
session_start();

// Redirect if admin not logged in
if (!isset($_SESSION['admin'])) {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $level = $_POST['level'];
    $type = $_POST['type'];
    $duration = $_POST['duration'];
    $price = $_POST['price'];
    $category_id = $_POST['category_id'];

    // File upload handling
    $file = $_FILES['file'];
    $file_name = $file['name'];
    $file_tmp  = $file['tmp_name'];
    $file_size = $file['size'];
    $file_error = $file['error'];

    if ($file_error === 0) {
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $allowed_ext = ['pdf', 'mp4', 'jpg', 'jpeg', 'png'];

        if (in_array($file_ext, $allowed_ext)) {
            if ($file_size < 350 * 1024 * 1024) { // 50MB max
                $file_new_name = uniqid('', true) . '.' . $file_ext;
                $file_destination = '../courses/' . $file_new_name;

                if (move_uploaded_file($file_tmp, $file_destination)) {
                    // Insert course into database
                    $stmt = $pdo->prepare('INSERT INTO courses 
                        (category_id,  name,  level, type, duration, price,  file) 
                        VALUES 
                        (:category_id, :name, :level, :type, :duration, :price,  :file)');

                    $stmt->execute([
                      'category_id' => $category_id,
                        'name'        => $name,
                        'level'       => $level,
                        'type'        => $type,
                        'duration'    => $duration,
                        'price'       => $price,
                        
                        'file'        => $file_new_name
                    ]);

                    header('Location: courses.php');
                    exit;
                } else {
                    $error = 'Failed to move uploaded file.';
                }
            } else {
                $error = 'File size exceeds 50MB limit.';
            }
        } else {
            $error = 'Invalid file type. Allowed: pdf, mp4, jpg, jpeg, png';
        }
    } else {
        $error = 'Error uploading file.';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Course</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f4f7;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 450px;
            background: white;
            margin: 60px auto;
            padding: 30px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            border-radius: 8px;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        form label {
            display: block;
            margin-top: 10px;
            font-weight: bold;
        }
        form input,
        form select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            margin-top: 5px;
        }
        button {
            display: block;
            width: 100%;
            padding: 12px;
            background: #0d6efd;
            border: none;
            border-radius: 4px;
            margin-top: 20px;
            color: white;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #0a58ca;
        }
        .error {
            background: #ffdddd;
            padding: 10px;
            border-left: 4px solid red;
            margin-bottom: 15px;
            color: #b10000;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Add Course</h2>

    <?php if (isset($error)) { ?>
        <div class="error"><?= $error ?></div>
    <?php } ?>

    <form method="post" enctype="multipart/form-data">
        <label>Name:</label>
        <input type="text" name="name" required>

        <label>Level:</label>
        <input type="text" name="level" required>

        <label>Type:</label>
        <input type="text" name="type" required>

        <label>Duration (days):</label>
        <input type="number" name="duration" required>

        <label>Price:</label>
        <input type="number" name="price" step="0.01" required>

        <label>Category:</label>
        <select name="category_id" required>
            <?php
            $stmt = $pdo->query('SELECT * FROM categories');
            $categories = $stmt->fetchAll();
            foreach ($categories as $category) {
                echo "<option value='{$category['id']}'>{$category['name']}</option>";
            }
            ?>
        </select>

        <label>Course File:</label>
        <input type="file" name="file" required>

        <button type="submit">Add Course</button>
    </form>
</div>
</body>
</html>
