<?php 
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';
// require_once 'admin_guard.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$courses = $pdo->query("SELECT * FROM courses")->fetchAll();

if($_POST){
    $stmt = $pdo->prepare("
    INSERT INTO assessments (course_id, assessment_title, total_questions, duration)
    VALUES (:c,:t,:q,:d)");
    $stmt->execute([
        'c'=>$_POST['course_id'],
        't'=>$_POST['title'],
        'q'=>$_POST['total'],
        'd'=>$_POST['duration']
    ]);
    header("Location: assessments.php");
}
?>

<form method="post">
<select name="course_id" class="form-control mb-2">
<?php foreach($courses as $c): ?>
<option value="<?= $c['id'] ?>"><?= $c['name'] ?></option>
<?php endforeach; ?>
</select>
<input name="title" class="form-control mb-2" placeholder="Assessment title">
<input name="total" class="form-control mb-2" placeholder="Total questions">
<input name="duration" class="form-control mb-2" placeholder="Duration (mins)">
<button class="btn btn-success">Save</button>
</form>
