<?php
// =========================
// DATABASE CONFIGURATION
// =========================
$db_host     = 'localhost';
$db_name     = 'vsb';
$db_user     = 'root';
$db_pass     = '';
$db_charset  = 'utf8mb4';

// Build DSN correctly
$dsn = "mysql:host=$db_host;dbname=$db_name;charset=$db_charset";

// PDO Options
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

// =========================
// CONNECT TO DATABASE
// =========================
try {
    $pdo = new PDO($dsn, $db_user, $db_pass, $options);
} catch (PDOException $e) {
    // In production, do NOT show raw error
    die("Database connection failed: " . htmlspecialchars($e->getMessage()));
}


// =========================
// HELPER FUNCTIONS
// =========================

// Check if logged in
function is_logged_in() {
    return isset($_SESSION['user']);
}

// Return current user
function current_user() {
    return $_SESSION['user'] ?? null;
}

// Restrict page to logged-in users
function require_login($redirect = '/login.php') {
    if (!is_logged_in()) {
        header('Location: ' . $redirect);
        exit;
    }
}
?>
